<?php
/**
 * @package	System - Google Analytics 4 Plugin
 * @version	1.2.3
 * @author	HikaShop
 * @copyright	(C) 2010-2025 HIKARI SOFTWARE. All rights reserved.
 * @license	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?><?php

use BluePsyduck\Ga4MeasurementProtocol\Config;
use BluePsyduck\Ga4MeasurementProtocol\Client;
use BluePsyduck\Ga4MeasurementProtocol\Serializer\Serializer;
use GuzzleHttp\Client as GuzzleClient;
use GuzzleHttp\Psr7\HttpFactory;
use Psr\Http\Client\ClientExceptionInterface;
use BluePsyduck\Ga4MeasurementProtocol\Request\Payload;
use BluePsyduck\Ga4MeasurementProtocol\Request\Event\PurchaseEvent;
use BluePsyduck\Ga4MeasurementProtocol\Request\Event\Item;

$pluginCompat = JPATH_ROOT.'/administrator/components/com_hikashop/pluginCompat.php';
if(file_exists($pluginCompat)) {
	include_once($pluginCompat);
	class plgSystemHikashop_ga4Bridge extends hikashopJoomlaPlugin{}
} else {
	class plgSystemHikashop_ga4Bridge extends JPlugin{}
}
#[\AllowDynamicProperties]
class plgSystemHikashop_ga4 extends plgSystemHikashop_ga4Bridge
{
	private $site_id;
	private $api_secret;
	private $debug;
	function __construct(&$subject, $config) {
		parent::__construct($subject, $config);

		if(!isset($this->params)){
			if(HIKASHOP_J50 && !class_exists('JPluginHelper'))
				class_alias('Joomla\CMS\Plugin\PluginHelper', 'JPluginHelper');
			if(HIKASHOP_J50 && !class_exists('JRegistry'))
				class_alias('Joomla\Registry\Registry', 'JRegistry');
			$plugin = JPluginHelper::getPlugin('system', 'hikashop_ga4');
			$this->params = new JRegistry(@$plugin->params);
		}
	}

	public function onBeforeCompileHead(){
		if(!class_exists('JFactory'))
			class_alias('Joomla\CMS\Factory', 'JFactory');
		$app = JFactory::getApplication();
		if(version_compare(JVERSION,'4.0','>=') && $app->isClient('administrator'))
			return true;
		if(version_compare(JVERSION,'4.0','<') && $app->isAdmin())
			return true;

		if (!defined('DS'))
			define('DS', DIRECTORY_SEPARATOR);
		if(!include_once(rtrim(JPATH_ADMINISTRATOR,DS).DS.'components'.DS.'com_hikashop'.DS.'helpers'.DS.'helper.php')) return true;

		$this->init();

		$options = '';
		if($this->debug) {
			$options = ", {'debug_mode': true}";
		}
		$user_id = hikashop_loadUser(false);
		if($user_id) {
			if(empty($options)) {
				$options = ", {'user_id': '".$user_id."'}";
			} else {
				$options = ", {'debug_mode': true, 'user_id': '".$user_id."'}";
			}
		}

		$js = "
window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments);}
gtag('js', new Date());

gtag('config', '".$this->site_id."'".$options.");

".$this->getCartJS()."
".$this->getProductJS()."
".$this->getCategoryJS()."
".$this->getCheckoutJS()."
".$this->getPurchaseJS()."

		";

		$doc = JFactory::getDocument();

		// START LEGALBLINK MODIFICATION (PRIOR BLOCKING)
		// Replaces addScript with addCustomTag to add the blocking attributes for the external gtag.js file.
		$doc->addCustomTag('<script type="text/plain" class="lb-third-party-stats-cookies" async src="https://www.googletagmanager.com/gtag/js?id='.$this->site_id.'"></script>');
		
		// Replaces addScriptDeclaration with addCustomTag to add the blocking attributes for the inline JS ($js).
		$doc->addCustomTag('<script type="text/plain" class="lb-third-party-stats-cookies">'.$js.'</script>');
		// END LEGALBLINK MODIFICATION

		/* // Original HikaShop code commented out:
		$doc->addScript('https://www.googletagmanager.com/gtag/js?id='.$this->site_id, array(), array('async'=>'async'));
		$doc->addScriptDeclaration($js);
		*/
		
	} // Chiusura della funzione onBeforeCompileHead()

	public function afterInitialise() {
		return $this->onAfterInitialise();
	}

	public function onAfterInitialise() {
		if(!empty($_POST['checkout']['ga4']['client_id'])) {
			if(!class_exists('JFactory'))
				class_alias('Joomla\CMS\Factory', 'JFactory');
			$app = JFactory::getApplication();
			$checkout = $app->input->get('checkout', '', 'array');
			$_SESSION['hikashop_ga4_client_id'] = $checkout['ga4']['client_id'];
		}
		if(!empty($_POST['checkout']['ga4']['session_id'])) {
			if(!class_exists('JFactory'))
				class_alias('Joomla\CMS\Factory', 'JFactory');
			$app = JFactory::getApplication();
			$checkout = $app->input->get('checkout', '', 'array');
			$_SESSION['hikashop_ga4_session_id'] = $checkout['ga4']['session_id'];
		}
	}

	public function onBeforeOrderCreate(&$order) {
		if(isset($order->order_type) && $order->order_type != 'sale')
			return;
		$app = JFactory::getApplication();
		if(hikashop_isClient('administrator'))
			return;

		if(!empty($order->order_payment_params) && is_string($order->order_payment_params))
			$order->order_payment_params = hikashop_unserialize($order->order_payment_params);
		if(empty($order->order_payment_params))
			$order->order_payment_params = new stdClass();

		$client_id = @$_SESSION['hikashop_ga4_client_id'];
		if(!empty($_POST['checkout']['ga4']['client_id'])) {
			$formData = hikaInput::get()->get('checkout', array(), 'array');
			$client_id = $formData['ga4']['client_id'];
		}
		if(!empty($client_id))
			$order->order_payment_params->ga4_client_id = trim($client_id);


		$session_id = @$_SESSION['hikashop_ga4_session_id'];
		if(!empty($_POST['checkout']['ga4']['session_id'])) {
			$formData = hikaInput::get()->get('checkout', array(), 'array');
			$session_id = $formData['ga4']['session_id'];
		}
		if(!empty($session_id))
			$order->order_payment_params->ga4_session_id = trim($session_id);
	}

	private function init() {
		$this->site_id = $this->params->get('g_id', '');
		$this->api_secret = $this->params->get('api_secret', '');
		$this->debug = (bool)$this->params->get('debug', false);
	}

	public function onHikashopBeforeDisplayView (&$view) {
		$app = JFactory::getApplication();

		$site = false;
		if(version_compare(JVERSION,'4.0','>=') && $app->isClient('site'))
			$site = true;
		if(version_compare(JVERSION,'4.0','<') && $app->isSite())
			$site = true;
		if(!$site)
			return;


		$page_view = $view->getName();
		$page_task = $view->getLayout();

		if($page_view == 'checkout' && in_array($page_task, array('show', 'step'))) {
			return $this->_handleCheckoutView($view);
		}

		if(!in_array($page_view, array( 'product', 'category')) || $page_task != 'listing' || empty($view->rows) || !hikaInput::get()->getVar('hikashop_front_end_main', 0))
			return;

		$first = reset($view->rows);
		if(!isset($first->product_id))
			return;

		$this->products =& $view->rows;
	}

	public function _handleCheckoutView(&$viewObj) {
		$this->init();
		if(empty($this->site_id))
			return;

		$viewObj->extra_data['hikashop_ga4'] = '
<input type="hidden" id="hikashop_checkout_ga4_client_id" name="checkout[ga4][client_id]" value="'.$viewObj->escape(@$_SESSION['hikashop_ga4_client_id']).'"/>
<input type="hidden" id="hikashop_checkout_ga4_session_id" name="checkout[ga4][session_id]" value="'.$viewObj->escape(@$_SESSION['hikashop_ga4_session_id']).'"/>
<script type="text/javascript">
window.hikashop.ready(function(){
	gtag("get", "'.$this->site_id.'", "client_id", function(clientID){
		var el = document.getElementById("hikashop_checkout_ga4_client_id");
		if(el && clientID)
			el.value = clientID;
	});
	gtag("get", "'.$this->site_id.'", "session_id", function(sessionID){
		var el = document.getElementById("hikashop_checkout_ga4_session_id");
		if(el && sessionID)
			el.value = sessionID;
	});
});
</script>';
	}

	public function onAfterOrderCreate(&$order) {
		if(isset($order->order_type) && $order->order_type != 'sale')
			return;

		return $this->checkOrder($order, true);
	}
	public function onAfterOrderUpdate(&$order) {
		if(isset($order->order_type) && $order->order_type != 'sale')
			return;

		return $this->checkOrder($order, false);
	}

	protected function checkOrder(&$order, $new = false) {
		if(!empty($order->order_type) && $order->order_type == 'subsale')
			return true;
		elseif(!empty($order->old->order_type) && $order->old->order_type == 'subsale')
			return true;
		elseif(empty($order->order_status))
			return true;

		$config = hikashop_config();
		$invoice_statuses = explode(',', $config->get('invoice_order_statuses', 'confirmed,shipped'));
		$isExportable = in_array($order->order_status, $invoice_statuses);
		$wasNotExportable = $new || !in_array($order->old->order_status, $invoice_statuses);
		$needToBeExported = $isExportable && $wasNotExportable;
		if(!$needToBeExported) {
			return;
		}

		$this->init();

		if(empty($this->api_secret))
			return;

		if(version_compare(PHP_VERSION,'8.0.0', '>=') === false) {
			hikashop_writeToLog('PHP8 required for GA4 measurement protocol');
			return;
		}

		require __DIR__.'/vendor/autoload.php';

		$guzzleClient = new GuzzleClient([
			\GuzzleHttp\RequestOptions::VERIFY => __DIR__.DS.'ca-bundle.crt'
		]);
		$httpFactory = new HttpFactory();
		$serializer = new Serializer();

		$clientConfig = new Config();
		$clientConfig->apiSecret = $this->api_secret;
		$clientConfig->measurementId = $this->site_id;

		$client = new Client(
			$guzzleClient, // Implementation of the PSR-18 ClientInterface 
			$httpFactory,  // Implementation of the PSR-17 RequestFactoryInterface
			$httpFactory,  // Implementation of the PSR-17 StreamFactoryInterface
			$serializer,   // Shipped with the library
			$clientConfig
		);

		$orderClass = hikashop_get('class.order');
		$orderData = $orderClass->loadFullOrder($order->order_id, false, false);
		$price_with_tax = $config->get('price_with_tax');
		$currencyClass = hikashop_get('class.currency');
		$currencies = null;
		$currencies = $currencyClass->getCurrencies($orderData->order_currency_id, $currencies);
		$currency_code = $currencies[$orderData->order_currency_id]->currency_code;
		$group = $config->get('group_options', 0);

		$purchaseEvent = new PurchaseEvent();
		$purchaseEvent->currency = $currency_code;
		$purchaseEvent->transactionId = $orderData->order_number;
		$purchaseEvent->value = round($orderData->order_full_price,2);

		foreach($orderData->products as $k => $product) {
			if(empty($product->order_product_quantity))
				continue;
			if($group && $product->order_product_option_parent_id)
				continue;

			$item = new Item();
			$item->itemId = $product->order_product_code;
			$item->itemName = strip_tags($product->order_product_name);
			$item->quantity = $product->order_product_quantity;
			$item->index = 0;


			if(!empty($product->order_product_discount_code)
				&& !empty($product->order_product_discount_info)) {
					$item->coupon = $product->order_product_discount_code;
				if(is_string($product->order_product_discount_info))
					$product->order_product_discount_info = hikashop_unserialize($product->order_product_discount_info);
					$discount = $product->order_product_price-$product->order_product_price_before_discount;
				if($price_with_tax) {
					$discount += $product->order_product_tax-$product->order_product_tax_before_discount;
				}
				$item->discount = round($discount, 2);

			}
			$brand = $this->getProductBrand($product);
			if(!empty($brand)) {
				$item->itemBrand = $brand;
			}
			if($product->order_product_price > 0.0) {
				$price = $product->order_product_price;
				if($price_with_tax) {
					$price += $product->order_product_tax;
				}
				$item->price = round($price, 2);
				$item->currency = $currency_code;
			}

			$categories = $this->getProductCategories($product);
			if(!empty($categories)) {
				$suffix = '';
				foreach($categories as $i => $category) {
					if($i > 4)
						break;
					$key = 'itemCategory'.$suffix;
					$item->$key = $category;
					$suffix = $i + 2;
				}
			}
			$purchaseEvent->items[] = $item;
		}

		if(!count($purchaseEvent->items))
			return;

		if(!empty($orderData->order_discount_code)) {
			$purchaseEvent->coupon = $orderData->order_discount_code;
			foreach($purchaseEvent->items as $k => $item) {
				$ratio = ($item->price * $item->quantity) / ($purchaseEvent->value+$orderData->order_discount_price);
				$coupon_ratio_amount = $orderData->order_discount_price * $ratio / $item->quantity;
				$item->price -= $coupon_ratio_amount;
				$item->discount = $coupon_ratio_amount;
			}

		}
		if(!empty($orderData->order_shipping_price))
			$purchaseEvent->shipping = round($orderData->order_shipping_price, 2);
		if(!empty($orderData->order_tax_info)) {
			if(is_string($orderData->order_tax_info))
				$orderData->order_tax_info = hikashop_unserialize($orderData->order_tax_info);
			$taxes = 0.0;
			foreach($orderData->order_tax_info as $tax) {
				$taxes+=$tax->tax_amount;
			}
			$purchaseEvent->tax = round($taxes, 2);
		}
		if(!$price_with_tax && !empty($purchaseEvent->tax)) {
			$purchaseEvent->value = $purchaseEvent->value - $purchaseEvent->tax;
		}
		$payload = new Payload();
		if(!empty($orderData->order_user_id))
			$payload->userId = $orderData->order_user_id;
		$payload->timestampMicros = time() * 1000000;
		$order_params = (!empty($orderData->order_payment_params) && is_string($orderData->order_payment_params)) ? hikashop_unserialize($orderData->order_payment_params) : $orderData->order_payment_params;
		if(!empty($order_params->ga4_client_id)){
			$payload->clientId = $order_params->ga4_client_id;
		} else {

			if($this->debug) {
				hikashop_writeToLog($purchaseEvent);
				hikashop_writeToLog('no client_id in order '.$orderData->order_id.'. The order_id will be used instead.');
			}
			$payload->clientId = $orderData->order_id;
		}
		if(!empty($order_params->ga4_session_id)){
			$purchaseEvent->session_id = $order_params->ga4_session_id;
			$purchaseEvent->engagement_time_msec = 1;
		} else {
			if($this->debug) {
				hikashop_writeToLog($purchaseEvent);
				hikashop_writeToLog('no session_id in order '.$orderData->order_id);
			}
		}
		$payload->events = [$purchaseEvent];


		if($this->debug) {
			hikashop_writeToLog($payload);
		}

		try {
			$client->send($payload);
		} catch (ClientExceptionInterface $e) {
			hikashop_writeToLog($payload);
			hikashop_writeToLog($e->getMessage());
		}

		return true;
	}


	private function getCategoryJS() {
		$js = '';

		$option = hikaInput::get()->getString('option');
		$ctrl = hikaInput::get()->getString('ctrl');
		$task = hikaInput::get()->getString('task');
		if(in_array($option, array('com_hikashop', '')) && in_array($ctrl, array('product', 'category')) && $task == 'listing') {
			$category = $this->getCategoryInfo();

			if(!empty($category) && !empty($this->products)) {
				$config = hikashop_config();
				$price_with_tax = $config->get('price_with_tax');
				$currencyClass = hikashop_get('class.currency');
				$currencies = null;
				$currency_id = hikashop_getCurrency();
				$currencies = $currencyClass->getCurrencies($currency_id, $currencies);
				$currency_code = $currencies[$currency_id]->currency_code;
				$items = array();
				foreach($this->products as $product) {
					$data = [
						'item_id' => json_encode($product->product_code),
						'item_name' => json_encode(strip_tags($product->product_name)),
						'index' => 0,
					];

					$price_key = 'price_value';
					$price_without_discount_key = 'price_value';
					if($price_with_tax) {
						$price_key = 'price_value_with_tax';
						$price_without_discount_key = 'price_value_with_tax';
					}


					if(!empty($product->prices[0]->discount)
						&& !empty($product->prices[0]->discount->discount_code)
						&& !empty($product->prices[0]->price_value_without_discount_with_tax)) {
						$data['coupon'] = json_encode($product->prices[0]->discount->discount_code);
						$price_without_discount_key = 'price_value_without_discount_with_tax';
						$data['discount'] = round($product->prices[0]->$price_without_discount_key-$product->prices[0]->$price_key, 2);

					}
					$brand = $this->getProductBrand($product);
					if(!empty($brand)) {
						$data['item_brand'] = json_encode($brand);
					}
					if(!empty($product->prices) && !empty($product->prices[0])) {
						$data['price'] = round($product->prices[0]->$price_without_discount_key, 2);
						$data['currency'] = json_encode($currency_code);
					}
					if($product->product_quantity > -1) {
						$data['quantity'] = (int)$product->product_quantity;
					}

					$categories = $this->getProductCategories($product);
					if(!empty($categories)) {
						$suffix = '';
						foreach($categories as $k => $cat) {
							if($k > 4)
								break;
							$data['item_category'.$suffix] = $cat;
							$suffix = $k + 2;
						}
					}

					$item = array();
					foreach($data as $k => $v) {
						$item[]=$k.':'.$v;
					}
					$item = '{'."\r\n".implode(','."\r\n",$item)."\r\n".'}';
					$items[] = $item;
				}
				$data  = [
					'item_list_id' => $category->category_id,
					'item_list_name' => json_encode($category->category_name),
					'items' => '['."\r\n".implode(','."\r\n",$items)."\r\n".']',
				];

				$item = array();
				foreach($data as $k => $v) {
					$item[]=$k.':'.$v;
				}
				$item = implode(','."\r\n",$item);
				$js .= "\r\n"."gtag('event', 'view_item_list', {"."\r\n".$item."\r\n"."});"."\r\n";
			}
		}

		return $js;
	}

	private function getProductJS() {
		$js = '';

		$option = hikaInput::get()->getString('option');
		$ctrl = hikaInput::get()->getString('ctrl');
		$task = hikaInput::get()->getString('task');
		if(in_array($option, array('com_hikashop', '')) && $ctrl == 'product' && $task != 'listing') {
			$product = $this->getProductInfo();

			if($product) {
				$config = hikashop_config();
				$price_with_tax = $config->get('price_with_tax');
				$price_key = 'price_value';
				$price_without_discount_key = 'price_value';
				if($price_with_tax) {
					$price_key = 'price_value_with_tax';
					$price_without_discount_key = 'price_value_with_tax';
				}
				$data = [
					'item_id' => json_encode($product->product_code),
					'item_name' => json_encode(strip_tags($product->product_name)),
					'index' => 0,
				];

				if(!empty($product->prices[0]->discount)
					&& !empty($product->prices[0]->discount->discount_code)
					&& !empty($product->prices[0]->price_value_without_discount_with_tax)) {
					$data['coupon'] = json_encode($product->prices[0]->discount->discount_code);
					$price_without_discount_key = 'price_value_without_discount_with_tax';
					$data['discount'] = round($product->prices[0]->$price_without_discount_key-$product->prices[0]->$price_key, 2);

				}
				$brand = $this->getProductBrand($product);
				if(!empty($brand)) {
					$data['item_brand'] = json_encode($brand);
				}
				if(!empty($product->prices) && !empty($product->prices[0])) {
					$data['price'] = round($product->prices[0]->$price_without_discount_key, 2);
					$data['currency'] = json_encode($product->currency_code);
				}
				if($product->product_quantity > -1) {
					$data['quantity'] = (int)$product->product_quantity;
				}

				$categories = $this->getProductCategories($product);
				if(!empty($categories)) {
					$suffix = '';
					foreach($categories as $k => $category) {
						if($k > 4)
							break;
						$data['item_category'.$suffix] = $category;
						$suffix = $k + 2;
					}
				}

				$item = array();
				foreach($data as $k => $v) {
					$item[]=$k.':'.$v;
				}
				$item = implode(','."\r\n",$item);
				$data  = [
					'items' => '[{'.$item.'}]',
				];
				if(!empty($product->prices) && !empty($product->prices[0])) {
					$data['value'] = round($product->prices[0]->$price_key, 2);
					$data['currency'] = json_encode($product->currency_code);
				}
				$item = array();
				foreach($data as $k => $v) {
					$item[]=$k.':'.$v;
				}
				$item = implode(','."\r\n",$item);
				$js .= "\r\n"."gtag('event', 'view_item', {"."\r\n".$item."\r\n"."});"."\r\n";
			}
		}

		return $js;
	}
	private function getCategoryInfo() {
		static $category = null;
		if($category !== null)
			return $category;

		$app = JFactory::getApplication();
		$category_id = (int)hikashop_getCID('category_id');

		if(empty($category_id)) {
			$menu = new stdClass();
			$moduleHelper = hikashop_get('helper.module');
			$config = hikashop_config();
			$config->set('no_css_header', 1);
			$moduleHelper->initialize($menu);
			$data = $menu->params->get('data', false);

			if($data === false) {
				$data = new stdClass();
				$data->hk_category = $menu->params->get('hk_category', false);
				if(!empty($data->hk_category))
					$data->hk_category = (object)$data->hk_category;
			}

			if(isset($data->hk_category) && is_object($data->hk_category)){
				$categoryId = (int)$menu->params->get('category', 0);
				if($categoryId > 0) {
					$cat = $categoryClass->get($categoryId);
					if($cat->category_type == 'manufacturer')
						$menu->params->set('content_type', 'manufacturer');
				}
				if(!empty($data->hk_category->category))
					$menu->params->set('selectparentlisting', (int)$data->hk_category->category);
			}
			$category_id = $menu->params->get('selectparentlisting');
		}
		$category = false;
		if(!empty($category_id)) {
			$categoryClass = hikashop_get('class.category');
			$category = $categoryClass->get($category_id);
		}
		return $category;
	}
	private function getProductInfo() {
		static $product = null;
		if($product !== null)
			return $product;

		$app = JFactory::getApplication();
		$product_id = (int)hikashop_getCID('product_id');
		$menus = $app->getMenu();
		$menu = $menus->getActive();
		if(empty($menu) && !empty($Itemid)) {
			$menus->setActive($Itemid);
			$menu = $menus->getItem($Itemid);
		}
		if(empty($product_id) && is_object($menu)) {
			if(!empty($menu)) {
				if(HIKASHOP_J30)
					$menuParams = $menu->getParams();
				else
					$menuParams = @$menu->params;
			}
			$product_id = $menuParams->get('product_id');
		}
		$product = false;
		if(!empty($product_id)) {
			$productClass = hikashop_get('class.product');
			$product = $productClass->get($product_id);
			if(!empty($product)) {
				if($product->product_type == 'variant') {
					$product = $productClass->get($product->product_parent_id);
				}
				$ids = array($product->product_id);
				$currencyClass = hikashop_get('class.currency');
				$currencyClass->getProductPrices($product, $ids, array());
				$currencies = null;
				$currency_id = hikashop_getCurrency();
				$currencies = $currencyClass->getCurrencies($currency_id, $currencies);
				$product->currency_code = $currencies[$currency_id]->currency_code;
			}
		}
		return $product;
	}
	private function getProductBrand(&$product) {
		if(!empty($product->product_manufacturer_id)) {
			$categoryClass = hikashop_get('class.category');
			$brand = $categoryClass->get($product->product_manufacturer_id);
			if(empty($brand))
				return '';
			return $brand->category_name;
		}
		return '';
	}
	private function getPurchaseJS() {

		$purchase_in_js = (int)$this->params->get('purchase_in_js', 1);
		if(!$purchase_in_js)
			return '';

		$option = hikaInput::get()->getString('option');
		$ctrl = hikaInput::get()->getString('ctrl');
		$task = hikaInput::get()->getString('task');
		$js = '';
		if(in_array($option, array('com_hikashop', '')) && $ctrl == 'checkout' && in_array($task, array('confirm', 'after_end'))) {
			$order_id = hikaInput::get()->getInt('order_id');
			if(empty($order_id)) {
				$app = JFactory::getApplication();
				$order_id = $app->getUserState('com_hikashop.order_id');
			}
			$order = null;
			if(empty($order_id)) {
				return '';
			}
			$orderClass = hikashop_get('class.order');
			$order = $orderClass->loadFullOrder($order_id, false, true);
			if(!$order) {
				return '';
			}
			$config = hikashop_config();
			$confirmed = array($config->get('order_confirmed_status', 'confirmed'));
			if($task == 'confirm' && !in_array($order->order_status, $confirmed)) {
				return '';
			}
			if(empty($order->products)) {
				return '';
			}
			$price_with_tax = $config->get('price_with_tax');
			$currencyClass = hikashop_get('class.currency');
			$currencies = null;
			$currencies = $currencyClass->getCurrencies($order->order_currency_id, $currencies);
			$currency_code = $currencies[$order->order_currency_id]->currency_code;
			$group = $config->get('group_options', 0);
			$items = array();
			foreach($order->products as $k => $product) {
				if(empty($product->order_product_quantity))
					continue;
				if($group && $product->order_product_option_parent_id)
					continue;
				$data = [
					'item_id' => json_encode($product->order_product_code),
					'item_name' => json_encode(strip_tags($product->order_product_name)),
					'quantity' => (int)$product->order_product_quantity,
					'index' => 0,
				];

				if(!empty($product->order_product_discount_code)
					&& !empty($product->order_product_discount_info)) {
					$data['coupon'] = json_encode($product->order_product_discount_code);
					if(is_string($product->order_product_discount_info))
						$product->order_product_discount_info = hikashop_unserialize($product->order_product_discount_info);
						$discount = $product->order_product_price-$product->order_product_price_before_discount;
					if($price_with_tax) {
						$discount += $product->order_product_tax-$product->order_product_tax_before_discount;
					}
					$data['discount'] = round($discount, 2);

				}
				$brand = $this->getProductBrand($product);
				if(!empty($brand)) {
					$data['item_brand'] = json_encode($brand);
				}
				if($product->order_product_price > 0.0) {
					$price = $product->order_product_price;
					if($price_with_tax) {
						$price += $product->order_product_tax;
					}
					$data['price'] = round($price, 2);
					$data['currency'] = json_encode($currency_code);
				}

				$categories = $this->getProductCategories($product);
				if(!empty($categories)) {
					$suffix = '';
					foreach($categories as $i => $category) {
						if($i > 4)
							break;
						$data['item_category'.$suffix] = $category;
						$suffix = $i + 2;
					}
				}

				$item = array();
				foreach($data as $k => $v) {
					$item[]=$k.':'.$v;
				}
				$item = '{'."\r\n".implode(','."\r\n",$item)."\r\n".'}';
				$items[] = $item;
			}

			if(!count($items))
				return '';
			$data  = [
				'transaction_id' => json_encode($order->order_number),
				'currency' => json_encode($currency_code),
				'value' => round($order->order_full_price,2),
				'items' => '['."\r\n".implode(','."\r\n",$items)."\r\n".']',
			];

			if(!empty($order->order_discount_code))
				$data['coupon'] = json_encode($order->order_discount_code);
			if(!empty($order->order_shipping_price))
				$data['shipping'] = round($order->order_shipping_price, 2);
			if(!empty($order->order_tax_info)) {
				if(is_string($order->order_tax_info))
				$order->order_tax_info = hikashop_unserialize($order->order_tax_info);
				$taxes = 0.0;
				foreach($order->order_tax_info as $tax) {
					$taxes+=$tax->tax_amount;
				}
				$data['tax'] = round($taxes, 2);
			}
			if(!$price_with_tax && !empty($data['tax'])) {
				$data['value'] = $data['value'] - $data['tax'];
			}
			$item = array();
			foreach($data as $k => $v) {
				$item[]=$k.':'.$v;
			}
			$item = implode(','."\r\n",$item);

			$js .= "\r\n"."gtag('event', 'purchase', {"."\r\n".$item."\r\n"."});"."\r\n";
			return $js;
		}
		return $js;
	}
	private function getCheckoutJS() {

		$option = hikaInput::get()->getString('option');
		$ctrl = hikaInput::get()->getString('ctrl');
		$task = hikaInput::get()->getString('task');
		$cid = hikaInput::get()->getInt('cid');

		if(in_array($option, array('com_hikashop', '')) && $ctrl == 'checkout' && in_array($task, array('step', 'show')) && empty($cid)) {
			return $this->getCartJS(true);
		}
		return '';
	}
	private function _isCartPage() {

		$view_cart = $this->params->get('view_cart', '');
		if($view_cart == 'all')
			return true;

		$option = hikaInput::get()->getString('option');
		$ctrl = hikaInput::get()->getString('ctrl');
		$task = hikaInput::get()->getString('task');
		if(
			in_array($option, array('com_hikashop', ''))
			&& (
				(
					$ctrl == 'checkout'
					&& in_array($task, array('step','show'))
				)
				|| 
				(
					$ctrl == 'cart'
					&& $task == 'show'
				)
			)
		) {
			return true;
		}



		$db = JFactory::getDBO();
		$filters = array("m.module = 'mod_hikashop_cart'", 'm.published = 1');

		$user = JFactory::getUser();
		$accesses = JAccess::getAuthorisedViewLevels(@$user->id);
		if(!empty($accesses)){
			$filters[]='m.access IN ('.implode(',',$accesses).')';
		}

		$lang = JFactory::getLanguage();
		$tag = $lang->getTag();
		$filters[] = "m.language IN ('*', '', ".$db->Quote($tag).")";

		$app = JFactory::getApplication();
		$menus = $app->getMenu();
		$menu = $menus->getActive();
		global $Itemid;
		if(empty($menu) && !empty($Itemid)) {
			$menus->setActive($Itemid);
			$menu = $menus->getItem($Itemid);
		}
		if($menu)
			$filters[] = '(mm.menuid = '.(int)$menu->id.' OR mm.menuid IS NULL)';
		else
			$filters[] = 'mm.menuid IS NULL';

		$xmlfile = JPATH_THEMES.DS.$app->getTemplate().DS.'templateDetails.xml';
		$xml = simplexml_load_file( $xmlfile );
		$positions = array();
		foreach ($xml->positions->position as $position) {
			$positions[] = $db->Quote($position);
		}
		$filters[] = 'm.position IN ('.implode(', ', $positions).')';

		$db->setQuery("SELECT count(m.id) FROM #__modules AS m LEFT JOIN #__modules_menu AS mm ON m.id = mm.moduleid WHERE ". implode(' AND ', $filters));
		$cartModules = $db->loadResult();
		if($cartModules)
			return true;

		return false;
	}
	private function getCartJS($checkout_mode = false) {
		$cartClass = hikashop_get('class.cart');
		$cart = $cartClass->getFullCart();

		$js = '';
		if(!empty($cart)) {
			if(!empty($cart->products) && $this->_isCartPage()) {
				$data = $this->getCartData($cart, $checkout_mode);
				if(!$data)
					return '';

				$item = array();
				foreach($data as $k => $v) {
					$item[]=$k.':'.$v;
				}
				$item = implode(','."\r\n",$item);

				$event = 'view_cart';
				if($checkout_mode)
					$event = 'begin_checkout';
				$js .= "\r\n"."gtag('event', '".$event."', {"."\r\n".$item."\r\n"."});"."\r\n";
			}
		}
		return $js;
	}

	private function getCartData(&$cart, $checkout_mode = true) {
		$config = hikashop_config();
		$price_with_tax = $config->get('price_with_tax');
		$price_key = 'price_value';
		$price_without_discount_key = 'price_value';
		if($price_with_tax) {
			$price_key = 'price_value_with_tax';
			$price_without_discount_key = 'price_value_with_tax';
		}
		$group = $config->get('group_options', 0);
		$currencyClass = hikashop_get('class.currency');
		$currencies = null;
		$currency_id = hikashop_getCurrency();
		$currencies = $currencyClass->getCurrencies($currency_id, $currencies);
		$currency_code = $currencies[$currency_id]->currency_code;
		$items = array();
		foreach($cart->products as $k => $product) {
			if(empty($product->cart_product_quantity) || substr($k,0,1) === 'p')
				continue;
			if($group && $product->cart_product_option_parent_id)
				continue;
			$data = [
				'item_id' => json_encode($product->product_code),
				'item_name' => json_encode(strip_tags($product->product_name)),
				'index' => 0,
			];

			if(!empty($product->prices[0]->discount)
				&& !empty($product->prices[0]->discount->discount_code)
				&& !empty($product->prices[0]->price_value_without_discount_with_tax)) {
				$data['coupon'] = json_encode($product->prices[0]->discount->discount_code);
				$price_without_discount_key = 'price_value_without_discount_with_tax';
				$data['discount'] = round($product->prices[0]->$price_without_discount_key-$product->prices[0]->$price_key, 2);

			}
			$brand = $this->getProductBrand($product);
			if(!empty($brand)) {
				$data['item_brand'] = json_encode($brand);
			}
			if(!empty($product->prices) && !empty($product->prices[0])) {
				$data['price'] = round($product->prices[0]->$price_without_discount_key, 2);
				$data['currency'] = json_encode($currency_code);
			}
			if($product->product_quantity > -1) {
				$data['quantity'] = (int)$product->product_quantity;
			}

			$categories = $this->getProductCategories($product);
			if(!empty($categories)) {
				$suffix = '';
				foreach($categories as $k => $category) {
					if($k > 4)
						break;
					$data['item_category'.$suffix] = $category;
					$suffix = $k + 2;
				}
			}

			$item = array();
			foreach($data as $k => $v) {
				$item[]=$k.':'.$v;
			}
			$item = '{'."\r\n".implode(','."\r\n",$item)."\r\n".'}';
			$items[] = $item;
		}

		$total = 0;
		if(!empty($cart->total->prices[0]->$price_key))
			$total = $cart->total->prices[0]->$price_key;

		if(!count($items) || empty($total))
			return false;
		$data  = [
			'currency' => json_encode($currency_code),
			'value' => round($total,2),
			'items' => '['."\r\n".implode(','."\r\n",$items)."\r\n".']',
		];

		if($checkout_mode) {
			if(!empty($cart->cart_coupon)){
				if(is_array($cart->cart_coupon))
					$coupon = reset($cart->cart_coupon);
				else
					$coupon = $cart->cart_coupon;
				$data['coupon'] = json_encode(trim((string)$coupon,"\r\n"));
			}
		}
		return $data;
	}

	public function onAfterCheckoutViewDisplay($layout, &$view, &$html) {
		if($layout == 'payment') {
			$cart = $view->checkoutHelper->getCart();
			if(!empty($cart->usable_methods->payment)) {
				foreach($cart->usable_methods->payment as $method) {
					if($method->payment_id == $cart->payment->payment_id) {
						$data = $this->getCartData($cart, $checkout_mode);
						if(!$data)
							return;
						$data['payment_type'] = json_encode($cart->payment->payment_name);
						$item = array();
						foreach($data as $k => $v) {
							$item[]=$k.':'.$v;
						}
						$item = implode(','."\r\n",$item);
						// START LEGALBLINK MODIFICATION
						// EN: Adds type="text/plain" and the blocking class for compliance (required for re-execution Hard-Fix).
						$html .= '<script type="text/plain" class="lb-third-party-stats-cookies">gtag(\'event\', \'add_payment_info\', {'."\r\n".$item."\r\n".'});'.'</script>';
						// END LEGALBLINK MODIFICATION
					}
				}
			}
			return;
		}
		if($layout == 'shipping') {
			$cart = $view->checkoutHelper->getCart();
			if(!empty($cart->usable_methods->shipping)) {
				if(count($cart->shipping_groups) > 1) {
					return;
				}

				foreach($cart->shipping_groups as $shipping_group_key => $group) {
					foreach($cart->usable_methods->shipping as $shipping) {
						$selected = false;
						if(!empty($cart->shipping)) {
							$shipping_id = is_numeric($shipping->shipping_id) ? (int)$shipping->shipping_id : $shipping->shipping_id;
							foreach($cart->shipping as $s) {
								$s_id = is_numeric($s->shipping_id) ? (int)$s->shipping_id : $s->shipping_id;
								if($s_id === $shipping_id) {
									$selected = true;
									break;
								}
							}
						}
						if($selected) {
							$data = $this->getCartData($cart, $checkout_mode);
							if(!$data)
								return;
							$data['shipping_tier'] = json_encode($shipping->shipping_name);
							$item = array();
							foreach($data as $k => $v) {
								$item[]=$k.':'.$v;
							}
							$item = implode(','."\r\n",$item);
							// START LEGALBLINK MODIFICATION
							// EN: Adds type="text/plain" and the blocking class for compliance (required for re-execution Hard-Fix).
							$html .= '<script type="text/plain" class="lb-third-party-stats-cookies">gtag(\'event\', \'add_shipping_info\', {'."\r\n".$item."\r\n".'});'.'</script>';
							// END LEGALBLINK MODIFICATION
						}
					}
				}
			}
			return;
		}
		return;
	}

	private function getProductCategories(&$product) {
		if(!isset($product->product_type)) {
			$productClass = hikashop_get('class.product');
			$data = $productClass->get($product->product_id);
			$product->product_type = $data->product_type;
			$product->product_parent_id = $data->product_parent_id;
		}
		$database = JFactory::getDBO();
		$query = 'SELECT b.category_name '.
			' FROM '.hikashop_table('product_category').' AS a '.
			' LEFT JOIN '.hikashop_table('category').' AS b ON a.category_id = b.category_id '.
			' WHERE a.product_id = '.(($product->product_type == 'variant' && !empty($product->product_parent_id)) ? (int)$product->product_parent_id : (int)$product->product_id).
			' AND b.category_published = 1 '.
			' ORDER BY a.product_category_id ASC';
		$database->setQuery($query, 0, 5);
		$categoriesData = $database->loadObjectList();

		if(!empty($categoriesData)) {
			$categories = array();
			foreach($categoriesData as $category) {
				if(!empty($category))
					$categories[] = json_encode($category->category_name);
			}
			return $categories;
		}
		return false;
	}
}
